CREATE OR REPLACE FUNCTION total_value() RETURNS DECIMAL(12,2) AS $$
DECLARE
    total DECIMAL(12,2);
BEGIN
    SELECT SUM(PS_SUPPLYCOST * PS_AVAILQTY) * 0.0001000000
    INTO total
    FROM PARTSUPP, SUPPLIER, NATION
    WHERE PS_SUPPKEY = S_SUPPKEY
      AND S_NATIONKEY = N_NATIONKEY
      AND N_NAME = 'GERMANY';

    RETURN total;
END;
$$ LANGUAGE plpgsql;
